import ollama

MODEL = 'qwen3:30b'

messages=[
  {'role': 'user', 'content': '10 + 20 は?'}
]

response = ollama.chat(
  model=MODEL,
  messages=messages,
  tools=[{
    'type': 'function',
    'function': {
      'name': 'evaluate_expression',
      'description': 'Evaluate the given expression',
      'parameters': {
        'type': 'object',
        'properties': {
          'expression': {
            'type': 'string',
            'description': 'The expression',
          },
        },
        'required': ['expression'],
      },
    },
  }],
)

result = None
if 'tool_calls' in response['message']:
  print('ツールが呼び出されました')
  messages.append(response['message'].model_dump())
  tool_calls = response['message']['tool_calls']
  expression = tool_calls[0].function.arguments['expression']
  messages.append({
      'role': 'tool',
      # セキュリティリスクがあるため、eval() をproductionで使用しないこと
      'content': str(eval(expression, {}, {}))
  })
  response = ollama.chat(
    model=MODEL,
    messages=messages,
  )
  result = response['message']['content']
else:
  result = response['message']['content']

print(result)
