import express from 'npm:express';
import axios from 'npm:axios';
import cors from 'npm:cors';
const app = express();
const PORT = 3000; // APIゲートウェイが外部からの接続を待ち受けるポート (本番では環境変数などに保存)
const UPSTREAM = 'http://localhost:11434' // Ollama APIをホストしているURL (本番では環境変数などに保存)

// API キーの例 (本番では環境変数などに保存)
const API_KEYS = {
  'your-secret-key': true,
};

app.use(express.json());

// ミドルウェアで API キーを検証
app.use((req, res, next) => {
  const apiKey = req.headers['x-api-key'];
  if (!apiKey || !API_KEYS[apiKey]) {
    return res.status(401).json({ error: 'Invalid API key' });
  }
  next();
});

// Ollama API にリクエストを転送
app.use('/api', async (req, res) => {
  const endpoint = `${UPSTREAM}${req.originalUrl}`;
  const options = {
    method: req.method,
    url: endpoint,
    data: req.body,
    responseType: 'stream',
    timeout: 30000,
  };

  try {
    console.log('REQUESTING:', options);
    const response = await axios(options);
    console.log('RESPONSE');
    response.data.pipe(res);
  } catch (error) {
    console.error('ERROR: ', error);
    res.status(error.response?.status || 500).json({
      error: error.message,
      details: error.response?.data,
    });
  }
});

// CORS 設定
app.use(cors());

app.listen(PORT, () => {
  console.log(`API Gateway is running on http://localhost:${PORT}`);
});
